package data.scripts.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipEngineControllerAPI;
import java.util.List;

public class SWP_LinkedHull extends BaseHullMod {

    private static void advanceChild(ShipAPI child, ShipAPI parent) {
        ShipEngineControllerAPI ec = parent.getEngineController();
        if (ec != null) {
            if (parent.isAlive()) {
                if (ec.isAccelerating()) {
                    child.giveCommand(ShipCommand.ACCELERATE, null, 0);
                }
                if (ec.isAcceleratingBackwards()) {
                    child.giveCommand(ShipCommand.ACCELERATE_BACKWARDS, null, 0);
                }
                if (ec.isDecelerating()) {
                    child.giveCommand(ShipCommand.DECELERATE, null, 0);
                }
                if (ec.isStrafingLeft()) {
                    child.giveCommand(ShipCommand.STRAFE_LEFT, null, 0);
                }
                if (ec.isStrafingRight()) {
                    child.giveCommand(ShipCommand.STRAFE_RIGHT, null, 0);
                }
                if (ec.isTurningLeft()) {
                    child.giveCommand(ShipCommand.TURN_LEFT, null, 0);
                }
                if (ec.isTurningRight()) {
                    child.giveCommand(ShipCommand.TURN_RIGHT, null, 0);
                }
            }

            ShipEngineControllerAPI cec = child.getEngineController();
            if (cec != null) {
                if ((ec.isFlamingOut() || ec.isFlamedOut()) && !cec.isFlamingOut() && !cec.isFlamedOut()) {
                    child.getEngineController().forceFlameout(true);
                }
            }
        }

        if (parent.isHulk() && parent.getHullSpec().getBaseHullId().contentEquals("swp_wall")) {
            child.setParentStation(null);
            child.setStationSlot(null);
        }
    }

    private static void advanceParent(ShipAPI parent, List<ShipAPI> children) {
        ShipEngineControllerAPI ec = parent.getEngineController();
        if (ec != null) {
            float originalMass;
            int originalEngines;
            switch (parent.getHullSpec().getBaseHullId()) {
                default:
                case "swp_wall":
                    originalMass = 5500f;
                    originalEngines = 19;
                    break;
                case "swp_boss_sporeship":
                    originalMass = 14700f;
                    originalEngines = 21;
                    break;
            }
            float thrustPerEngine = originalMass / originalEngines;

            /* Don't count parent's engines for this stuff - game already affects stats */
            int zeroFluxBoost = ec.getShipEngines().size();
            float workingEngines = ec.getShipEngines().size();
            int currentEngines = ec.getShipEngines().size();
            for (ShipAPI child : children) {
                if (child.getParentStation() == parent && child.getStationSlot() != null && child.isAlive()) {
                    ShipEngineControllerAPI cec = child.getEngineController();
                    if (cec != null) {
                        if (child.getFluxTracker().isEngineBoostActive()) {
                            zeroFluxBoost += cec.getShipEngines().size();
                        }
                        workingEngines += cec.getShipEngines().size() * (1f - cec.computeDisabledFraction());
                        currentEngines += cec.getShipEngines().size();
                    }
                }
            }

            float thrust = workingEngines * thrustPerEngine;
            float enginePerformance = thrust / Math.max(1f, parent.getMassWithModules());
            float zeroFluxPercentage = zeroFluxBoost / Math.max(1f, (float) currentEngines);
            parent.getMutableStats().getAcceleration().modifyMult("swp_linkedhull", enginePerformance);
            parent.getMutableStats().getDeceleration().modifyMult("swp_linkedhull", enginePerformance);
            parent.getMutableStats().getTurnAcceleration().modifyMult("swp_linkedhull", enginePerformance);
            parent.getMutableStats().getMaxTurnRate().modifyMult("swp_linkedhull", enginePerformance);
            parent.getMutableStats().getMaxSpeed().modifyMult("swp_linkedhull", enginePerformance);
            parent.getMutableStats().getZeroFluxSpeedBoost().modifyMult("swp_linkedhull", zeroFluxPercentage);
        }
    }

    @Override
    public void advanceInCombat(ShipAPI ship, float amount) {
        ShipAPI parent = ship.getParentStation();
        if (parent != null) {
            advanceChild(ship, parent);
        }

        List<ShipAPI> children = ship.getChildModulesCopy();
        if (children != null && !children.isEmpty()) {
            advanceParent(ship, children);
        }
    }
}
